/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.PDU;
import apicore.ptmp.PtmpBuffer;
import java.util.ArrayList;

public class CustomPdu
extends PDU {
    public ArrayList<Byte> bytes = new ArrayList();

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putInt(this.bytes.size());
        for (int i = 0; i < this.bytes.size(); ++i) {
            ptmpBuffer.putByte(this.bytes.get(i));
        }
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            int n = ptmpBuffer.getInt();
            this.bytes = new ArrayList();
            for (int i = 0; i < n; ++i) {
                this.bytes.add(ptmpBuffer.getByte());
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static CustomPdu create(PtmpBuffer ptmpBuffer) {
        CustomPdu customPdu = new CustomPdu();
        if (customPdu.deserialize(ptmpBuffer)) {
            return customPdu;
        }
        return null;
    }

    public String getTypeName() {
        return "CCustomPdu";
    }

    public String toString() {
        String string = "";
        string = string + super.toString() + "[CustomPdu: length=" + this.bytes.size() + ", data=" + this.bytes + "]";
        return string;
    }
}

